class MW_EndGameTrigger extends NavigationPoint;

function Touch(Actor Other)
{
	local Pawn P;
	local GameReplicationInfo GRI;

	if ( !Other.bIsPawn || !Pawn(Other).bIsPlayer )
		return;

	GRI.GameEndedComments = "PortalReached";

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		if ( P.IsA('PlayerPawn'))
			{
			P.ClientGameEnded();
			P.GotoState('GameEnded');
			}
}


defaultproperties
{
     bStatic=False
     bNoDelete=True
     bAlwaysRelevant=True
     Physics=PHYS_Rotating
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Mesh
     Texture=Texture'Botpack.Skins.JDomN0'
     Mesh=LodMesh'Botpack.DomN'
     DrawScale=0.100000
     AmbientGlow=255
     bUnlit=True
     bMeshEnviroMap=True
     SoundRadius=64
     SoundVolume=255
     bCollideActors=True
     LightType=LT_SubtlePulse
     LightEffect=LE_FireWaver
     LightBrightness=192
     LightHue=170
     LightSaturation=127
     LightRadius=8
     LightPeriod=32
     VolumeBrightness=32
     bFixedRotationDir=True
     RotationRate=(Yaw=5000)
     DesiredRotation=(Yaw=30000)
     CollisionRadius=4
     CollisionHeight=32
}
